d("headerView",['ccrz', 'util'], function(CCRZ, UTIL) {
    return {
        extendHeaderView: function() {
            if(!_.isUndefined(CCRZ.pagevars.queryParams['search'])){
                UTIL.showLoader();
            }
            CCRZ.pubSub.once('view:cartHeaderView:refresh', function(cartHeaderView){
                cartHeaderView.render = function(){
                    this.setElement($(CCRZ.uiProperties.cartHeaderView.desktop.selector));
                    var hdrModel = CCRZ.headerModel.get("header");
                    var source = ''||CCRZ.pagevars.pageLabels["CartHeader_Loading"];
                    if(hdrModel.get("cartTotal")){
                     var json = hdrModel.toJSON();
                     source = (CCRZ.display.isPhone()) ? this.templateCartHeaderPhone(json) : this.templateCartHeaderDesktop(json);
                    }
                    $(CCRZ.uiProperties.cartHeaderView.desktop.selector).each(function(){
                        $(this).html(source);
                    });
                    CCRZ.pubSub.trigger("view:"+this.viewName+":refresh", this);
                };
                cartHeaderView.render();
            });
            CCRZ.pubSub.once('view:productSearchView:refresh', function(searchView){
                searchView.events['click #doSearch'] = 'handleSearch';
                searchView.handleSearch = function(event){
                    debugger;
                    var keyEvent = jQuery.Event("keyup");
                    keyEvent.keyCode = 13;
                    $("#searchText").trigger(keyEvent);
                };
                searchView.enterPress = function(e){
                    debugger;
                    var code = e.keyCode; // recommended to use e.which, it's normalized across browsers
                    if(code==13)e.preventDefault();
                    if(CCRZ.disableAdaptive) {
                     $('#cc_search_error').popover('hide');
                    }
                    if(code==13){
                     this.doSearch(e);
                    }
                };
                searchView.doSearch = function(event){
                    if(this.validateSearchInput()){
                        debugger;
                        let searchText = $.trim($("#searchText").val());
                        let URL = '', currentParams = '';
                        for(let key in CCRZ.pagevars.queryParams){
                            if(key != 'categoryId' && key != 'search' && key != 'pageKey'){
                                currentParams += '&' + key + '=' + CCRZ.pagevars.queryParams[key];
                            } else if(key == 'search'){
                                currentParams += '&searchText=' + CCRZ.pagevars.queryParams[key];
                            }
                        }
                        if(UTIL.isCSRFlow()){
                            URL = CCRZ.pageUrls.productList + '?operation=quickSearch&searchText='+encodeURIComponent(searchText) + currentParams;
                        } else {
                            URL = CCRZ.pageUrls.productList + '?operation=quickSearch&searchText='+encodeURIComponent(searchText) + currentParams;
                        }
                        window.location.href = window.location.origin + URL;
                    }
                }
                searchView.delegateEvents();
                if(!_.isUndefined(CCRZ.pagevars.queryParams['search'])){
                    debugger;
                    UTIL.showLoader();
                    $('#searchText').val(CCRZ.pagevars.queryParams['search']);
                    searchView.doSearch(null);
                }
            });
            CCRZ.pubSub.once('view:headerView:refresh', function(headerView){
                $('#dismiss').on('click', function () {
                    $('#sidebar').removeClass('active');
                    $('#sidebarBackdrop').addClass('hide');
                });
                headerView.events['click #cartDrop'] = 'renderMiniCart';
                headerView.events['click .toggle-btn-top'] = 'toggleTopMenu';
                headerView.toggleTopMenu = function(event){
                    let x = document.getElementById("top-header-links");
                    if (x.className === "top-header-links") {
                        x.className += " responsive";
                    } else {
                        x.className = "top-header-links";
                    }
                };
                headerView.hideLoader = function(){
                    let loadingParent = $(".main-loader");
                    if(loadingParent){
                        var loaderClassName = loadingParent.attr("class");
                        if(loaderClassName && loaderClassName.indexOf("loading") >= 0){
                            loadingParent.removeClass("loading");
                        }
                    }
                };
                headerView.renderMiniCart = function(event){
                    if(CCRZ.pagevars.currentPageName == 'ccrz__OrderConfirmation' || CCRZ.pagevars.currentPageName == 'ccrz__Cart'){
                        return false;
                    } else if(CCRZ.pagevars.currentPageName == 'ccrz__CheckoutNew' || CCRZ.pagevars.currentPageName == 'ccrz__SubscriptionDetail'
                    || CCRZ.pagevars.currentPageName == 'ccrz__StoredPaymentDetail' || CCRZ.pagevars.currentPageName == 'ccrz__OrderView'
                    || CCRZ.pagevars.currentPageName == 'ccrz__InvoiceDetail' || CCRZ.pagevars.currentPageName == 'ccrz__InvoicePayment'
                    || CCRZ.pagevars.currentPageName == 'ccrz__CCPage'){
                        headerView.goToCart();
                    } else {
                        $('#sidebar').addClass('active'); 
                        $('.sidebarMiniCart').removeClass('hide');
                        $('#sidebarBackdrop').removeClass('hide');
                    }
                };
                headerView.delegateEvents();
                window.setTimeout(function(){
                    headerView.render();
                    CCRZ.menuView.render();
                    CCRZ.productSearchView.render();
                    CCRZ.effSelectorView.render();
                }, 4500);
            });
            CCRZ.pubSub.on("view:headerView:refresh", function(view){
                var ua = window.navigator.userAgent;
                var msie = ua.indexOf("MSIE");
                var trident = ua.indexOf('Trident/');
                if (trident > 0 || msie > 0) 
                {
                    CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM', severity : 'ERROR',
                            message : CCRZ.pagevars.pageLabels.CHVAC_Header_IE_Warning,
                            classToAppend : 'messagingSection-Error'
                            }
                        ]
                    });
                    
                }
            });
        }
    }
});